var reminderFoxBundle = document.getElementById("reminderFox-bundle");  
var reminderFox_snoozed = false;
var reminderFox_okayed = false;

var reminderFox_reopeningWindow = false;

const REMINDERFOX_ACTION_TYPE = { ACKNOWLEDGE: 0, COMPLETE : 1, DELETE : 2, OPEN : 3, SNOOZE : 4 };
const MAX_TAB_TITLE_LENGTH = 30;
var reminderAlarmArray = new Array();
var reminderFox_QAcalendarOpened = false;

function updateTimeUntil() {
//dump( "FOCUSE" );  
// after FIRST focus; see if focus lost happens within a second...
// or on WINDOW load start a timer - then see if onFocusLeave happens quickly.  If so probably need to re-alert in 
// X-minutes.  As part of re-alert, maybe re-open the window to retrieve focus again?  
	var tabList = document.getElementById("tabList");
	if (tabList != null) {
		var index = tabList.selectedIndex;
		
		if (index < reminderAlarmArray.length) {
			var recentReminder = reminderAlarmArray[index].alarmRecentReminder;
			
			if (getChildElementByIdForCurrentTab("timeUntilHBox") != null) {  
			
				if (getChildElementByIdForCurrentTab("timeUntilHBox").getAttribute("hidden") != "true" &&
				getChildElementByIdForCurrentTab("timeUntilHBox").getAttribute("hidden") != true) {
					if ( recentReminder != null ) {
						var timeUntil = reminderFox_getTimeUntilDate(recentReminder.date, recentReminder);
						
						if (timeUntil != null && timeUntil != "") {
							getChildElementByIdForCurrentTab("timeUntilText").setAttribute("value", timeUntil);
						}
						else {
							// the time has passed:  remove TimeUntil:  
							// note: setting hidden property did some strange redrawing of elements; instead
							// let's just clear the text from the labels
							//getChildElementByIdForCurrentTab("timeUntilHBox").setAttribute("hidden", "true");
							getChildElementByIdForCurrentTab("timeUntilLabel").setAttribute("value", "");
							getChildElementByIdForCurrentTab("timeUntilText").setAttribute("value", "");
						}
					}
					else { 
						// a quickalarm - remove TimeUntil:
						getChildElementByIdForCurrentTab("timeUntilLabel").setAttribute("value", "");
						getChildElementByIdForCurrentTab("timeUntilText").setAttribute("value", "");
					}
				}
				reminderFox_updateSnoozeTimeDate();
			}
		}
	}
}


function loadAlarm(){
	reminderFox_reopeningWindow = false;

	reminderAlarmArray = window.arguments[0].alarmInfos;
	
	var panels = document.getElementById("tabPanelID");
	var tabList = document.getElementById("tabList");
	
		
	// see if any notes...
	var hasNotes = false;
	for ( var i = 0; i < reminderAlarmArray.length; i++ ) {
		if ( (reminderAlarmArray[i].alarmRecentReminder !=null && reminderAlarmArray[i].alarmRecentReminder.notes != null ) ||
				(reminderAlarmArray[i].quickAlarmNotes != null && reminderAlarmArray[i].quickAlarmNotes.length > 0 && 
					reminderAlarmArray[i].quickAlarmNotes != "null" ) ) { 
			hasNotes = true;
		}
	}
	
	for ( var i = 0; i < reminderAlarmArray.length; i++ ) {
		var tabTitle = null;
		if ( reminderAlarmArray[i].alarmRecentReminder != null ) {
			reminderAlarmArray[i].alarmRecentReminder  = reminderFox_processReminderDescription(
				reminderAlarmArray[i].alarmRecentReminder, new Date().getFullYear(), reminderAlarmArray[i].alarmIsTodo);	
			tabTitle = reminderAlarmArray[i].alarmRecentReminder.summary;
		}
		else {
			tabTitle = reminderAlarmArray[i].quickAlarmText;
		}
		if ( tabTitle != null && tabTitle.length > MAX_TAB_TITLE_LENGTH ) {
			tabTitle = tabTitle.substring( 0, MAX_TAB_TITLE_LENGTH );
		}
		
		var tabPanel = null;
		if (i == 0) {
			tabPanel = panels.childNodes[0];
			var tab = tabList.childNodes[0];
			tab.setAttribute("label", tabTitle);
			reminderAlarmArray[i].alarmTabPanel = tabPanel;
		}
		else {
			var remindersTab = panels.childNodes[0];
			var newTabList = document.createElement("tab");
			newTabList.setAttribute("id", "reminderFoxList:1");
			newTabList.setAttribute("label", tabTitle);
			tabList.appendChild(newTabList);
		
			var newtabpanel = remindersTab.cloneNode(true);
			newtabpanel.setAttribute("id", "reinderFoxListPanel:1");
			panels.appendChild(newtabpanel);
			reminderAlarmArray[i].alarmTabPanel = newtabpanel;
			tabList.selectedIndex = tabList.childNodes.length-1;
		}
		
		var tabbox = document.getElementById("tabbox");	
		tabbox.selectedPanel = reminderAlarmArray[i].alarmTabPanel ;
		
		initializeAlarm( reminderAlarmArray[i], hasNotes, i==0 );
		
	}
	
	playAlarmSound();
	selectAlarmTab();
	
	
	// ensure last tab is selected and visible
	var arrowscrollbox = document.getElementById("arrowscrollbox");	
	var lasttab = tabList.childNodes[tabList.childNodes.length-1];
	arrowscrollbox.scrollByIndex( tabList.childNodes.length-1 );
	arrowscrollbox.ensureElementIsVisible( lasttab );
	arrowscrollbox.scrollByPixels( 100 );
}




function getChildElementById(parentNode, elementId){
	for (var i = 0; i < parentNode.childNodes.length; i++) {
		var node = parentNode.childNodes[i];
		if ( node.id == elementId ) {
			return node;
		}
		else {
			var foundNode = getChildElementById( node, elementId );
			if ( foundNode != null ) {
				return foundNode;
			}
		}
	}
	return null;
}

function getChildElementByIdForCurrentTab(elementId){
	var tabbox = document.getElementById("tabbox");	
	if ( tabbox == null ) {
		return document.getElementById(elementId);
	}
	var parentNode =	tabbox.selectedPanel;
	var node =  getChildElementById( parentNode, elementId );
	if (node != null) {
		return node;
	}
	else {
		return document.getElementById(elementId);
	}
		
		
}

// truncate the link text that is displayed to 80 chars; 
// otherwise the alarm window widens to accomodate it
// and it can get out of hand
function reminderFox_getLinkDisplayText(linkurl){
	if (linkurl.length > 80) {
		return linkurl.substring(0, 80) + "...";
	}
	else {
		return linkurl;
	}
}


function initializeAlarm( reminderAlarmOptions, hasNotes, firstTab) { 
	var tabPanel = reminderAlarmOptions.alarmTabPanel;
	var recentReminder = reminderAlarmOptions.alarmRecentReminder;
	
	var quickAlarmText = reminderAlarmOptions.quickAlarmText;
	var snoozeTime = reminderAlarmOptions.alarmSnoozeTime;
	var listName = reminderAlarmOptions.alarmListName;
	var isTodo = reminderAlarmOptions.alarmIsTodo;
	var isReminder = reminderAlarmOptions.alarmIsReminder;
	var alarmMissed = reminderAlarmOptions.alarmAlarmMissed;
	var snoozeTimeList = getChildElementById(tabPanel, "reminderFox-snoozeTime");
	var timeUnitsList = getChildElementById(tabPanel, 'reminderFox-alertTimeUnits');
	var actionList = getChildElementByIdForCurrentTab("reminderFox-alarm-action");
	if (snoozeTime != null && reminderFox_isInteger(snoozeTime)) {
		var snoozeTimeInt = parseInt(snoozeTime);
		if (snoozeTimeInt == 0) {
			snoozeTimeList.label = snoozeTime;
			timeUnitsList.selectedIndex = 0;
		}
		else 
			if (reminderFox_mod(snoozeTimeInt, (60 * 24)) == 0) {
				// days
				snoozeTimeList.label = (snoozeTimeInt / (60 * 24));
				timeUnitsList.selectedIndex = 2;
			}
			else 
				if (reminderFox_mod(snoozeTimeInt, 60) == 0) {
					// hours
					snoozeTimeList.label = (snoozeTimeInt / 60);
					timeUnitsList.selectedIndex = 1;
				}
				else {
					// minutes
					snoozeTimeList.label = snoozeTime;
					timeUnitsList.selectedIndex = 0;
				}
	}
	else {
		// set initial snooze values from defaults
		var snoozeTime =	5;
		var snoozeUnitsIndex = 0;
		var defaultActionIndex = 0;
	 	 try {
			snoozeTime = reminderFox_prefs.getIntPref(REMINDER_FOX_PREF + "." +  REMINDER_FOX_DEFAULTS_ALARM_SNOOZE_TIME);
			if (snoozeTime != null && reminderFox_isInteger(snoozeTime)) {
				snoozeTimeList.label = snoozeTime;
			}
			snoozeUnitsIndex = reminderFox_prefs.getIntPref(REMINDER_FOX_PREF + "." +  REMINDER_FOX_DEFAULTS_ALARM_SNOOZE_UNITS);
			if (snoozeUnitsIndex != null && reminderFox_isInteger(snoozeUnitsIndex)) {
				timeUnitsList.selectedIndex = snoozeUnitsIndex;
			}
			
		 }
		 catch ( e) {
		 }
	}
	defaultActionIndex = reminderFox_prefs.getIntPref(REMINDER_FOX_PREF + "." +  REMINDER_FOX_DEFAULTS_ALARM_SNOOZE_ACTION);
	if (defaultActionIndex != null && reminderFox_isInteger(defaultActionIndex)) {
		actionList.selectedIndex = defaultActionIndex;
	}

	
	if ( quickAlarmText != null ) {
		getChildElementById(tabPanel, "reminderDescriptionText").setAttribute("value", quickAlarmText);							
	}
	else {

		recentReminder  = reminderFox_processReminderDescription(recentReminder, new Date().getFullYear(), isTodo);	
		
		var reminderString =  recentReminder.summary;
		getChildElementById(tabPanel, "reminderDescriptionText").setAttribute("value", reminderString);				

		var dateVariableString;
		try {
			dateVariableString = reminderFox_getUnicodePref(REMINDER_FOX_PREF + "." + REMINDER_FOX_LIST_DATE_LABEL);
		} catch(e) {
		}			
		var dateString =reminderFox_getDateVariable( null, recentReminder.date, dateVariableString );		
		
		document.title =reminderFox_getBundle().getString( "rf.alarm.title" );
		if ( listName != null && listName.length > 0 && listName != "null" ) {
			document.title += " [" + listName  + "]";
		}
		
		// if this is a past reminder, indicate that in the title
		if (  alarmMissed == "true" ) {
			// only show missed if the event itself has been missed...
			var currentDate = new Date();
			var compare = 0;
			if ( recentReminder.allDayEvent )  {
				// compare dates
				compare = reminderFox_compareDates( currentDate, recentReminder.date );
			}
			else {
				// compare dates and times
				compare = reminderFox_compareAlarmTimes( currentDate, recentReminder.date );
			}
			
			if ( compare == 1 ) {
			// compare Dates: recentReminder.date, currentDate.  
			// if current date is after reminder date, show 'missed'
				document.title = 	document.title + " (" + reminderFox_getBundle().getString( "rf.alarm.missedalarm.title" )  + ")";
			}
		}
		
	
		
		document.title = 	document.title + ": " + reminderString;
		
		getChildElementById(tabPanel, "reminderDateText").setAttribute("value", dateString);
		
		var timeString = reminderFox_getTimeString(recentReminder, recentReminder.date);
		if (timeString == null) {
			timeString = reminderFox_getBundle().getString("rf.add.time.allday");
		}
		
		getChildElementById(tabPanel, "reminderTimeText").setAttribute("value", timeString );
		
		var timeUntil =  reminderFox_getTimeUntilDate( recentReminder.date, recentReminder);
		if ( timeUntil != null && timeUntil != "" ) {
			getChildElementById(tabPanel, "timeUntilHBox").removeAttribute( "hidden");
			getChildElementById(tabPanel, "timeUntilText").setAttribute("value", timeUntil);
		}
		else {
			getChildElementById(tabPanel, "timeUntilHBox").setAttribute( "hidden", true);
			getChildElementById(tabPanel, "timeUntilText").setAttribute("value", "");
		}

	}
	
	
	
	
	
	if ( recentReminder != null ) {
		getChildElementById(tabPanel, "reminderFox-alarm-action").removeAttribute( "hidden");
	}
	else {
		getChildElementById(tabPanel, "reminderFox-alarm-action").setAttribute( "hidden", true);
	}
	
	
	if ( recentReminder != null && recentReminder.date != null ) {
		getChildElementById(tabPanel, "reminderDateText").removeAttribute( "hidden");
		getChildElementById(tabPanel, "reminderDateLabel").removeAttribute( "hidden");
		getChildElementById(tabPanel, "timeDescLabel").removeAttribute( "hidden");
		getChildElementById(tabPanel, "reminderTimeText").removeAttribute( "hidden");
		
	}
	else {
		getChildElementById(tabPanel, "reminderDateLabel").setAttribute( "hidden", true);
		getChildElementById(tabPanel, "reminderDateText").setAttribute( "hidden", true);
		getChildElementById(tabPanel, "timeDescLabel").setAttribute( "hidden", true);
		getChildElementById(tabPanel, "reminderTimeText").setAttribute( "hidden", true);
	}

	
			

	// DisplayMail Icon -----------
	var displayMailButton = getChildElementById(tabPanel, "displayMail");
	if (recentReminder !=null && recentReminder.messageID != null) {
		displayMailButton.setAttribute('style', 'visibility: visible');
		displayMailButton.setAttribute('disabled', 'false');
	}
	else {
		displayMailButton.setAttribute('style', 'display: none;');
		displayMailButton.setAttribute('disabled', 'true');
	}

	

	var tabbox = document.getElementById("tabbox");	
	var selectedPanel =	tabbox.selectedPanel;
	
	if ( recentReminder !=null && recentReminder.priority == REMINDER_PRIORITY_IMPORTANT) { 
		getChildElementById(tabPanel, "reminderDescriptionText").setAttribute("style", "color: red;");
	}
	else {
		getChildElementById(tabPanel, "reminderDescriptionText").setAttribute("style", "");
	}
	
	if ( (recentReminder !=null && recentReminder.notes != null ) || 
		(reminderAlarmOptions.quickAlarmNotes != null && reminderAlarmOptions.quickAlarmNotes.length > 0 && 
			reminderAlarmOptions.quickAlarmNotes != "null") ) { 
		if ( reminderAlarmOptions.quickAlarmNotes != null && 
			reminderAlarmOptions.quickAlarmNotes.length > 0 && reminderAlarmOptions.quickAlarmNotes != "null") {
			// to replace \n char with actual newlines:
			reminderAlarmOptions.quickAlarmNotes = reminderAlarmOptions.quickAlarmNotes.replace(new RegExp(/\\n/g),"\n");		
			
			getChildElementById(tabPanel, "notesText").setAttribute("value", reminderAlarmOptions.quickAlarmNotes);		
		}
		else {
			getChildElementById(tabPanel, "notesText").setAttribute("value", recentReminder.notes);
		}		
		getChildElementById(tabPanel, "notesText").removeAttribute( "hidden");
		getChildElementById(tabPanel, "notesHbox").removeAttribute( "hidden");
	}
	else {
		getChildElementById(tabPanel, "notesText").setAttribute("value", null);	
		
		if ( hasNotes && firstTab ) { 
			// if this is the first tab and one of the tabs has notes on it, then
			// make sure the notes is visible (for sizing) since this tab is the onw 
			// that will be cloned
			getChildElementById(tabPanel, "notesHbox").removeAttribute( "hidden");
			getChildElementById(tabPanel, "notesText").removeAttribute( "hidden");
		}
		else {
			getChildElementById(tabPanel, "notesHbox").setAttribute( "hidden", true);	
			getChildElementById(tabPanel, "notesText").setAttribute( "hidden", true);
		}
	}
	
	if ( recentReminder != null && recentReminder.location != null && recentReminder.location.length > 0 ) {
		getChildElementById(tabPanel, "locationText").setAttribute("value", recentReminder.location);		
		getChildElementById(tabPanel, "locationHbox").removeAttribute( "hidden");
	}
	else {
		getChildElementById(tabPanel, "locationText").setAttribute("value", null);		
		getChildElementById(tabPanel, "locationHbox").setAttribute( "hidden", true);
	}
	
	if ( recentReminder != null && recentReminder.url != null && recentReminder.url.length > 0 ) {
		getChildElementById(tabPanel, "urlText").setAttribute("value", reminderFox_getLinkDisplayText( recentReminder.url) );		
		getChildElementById(tabPanel, "urlText").setAttribute("reminderHref", recentReminder.url);	
		getChildElementById(tabPanel, "urlText").setAttribute("tooltiptext", recentReminder.url);	
		getChildElementById(tabPanel, "urlhbox").removeAttribute( "hidden");
	}
	else {
		getChildElementById(tabPanel, "urlText").setAttribute("value", null);		
		getChildElementById(tabPanel, "urlText").setAttribute("reminderHref", null);	
		getChildElementById(tabPanel, "urlText").setAttribute("tooltiptext", null);		
		getChildElementById(tabPanel, "urlhbox").setAttribute( "hidden", true);
	}
	
 	 // get preference for how many minutes to re-sound the alarm	
 	 var soundInterval =	-1;
 	 try {
		soundInterval = reminderFox_prefs.getIntPref(REMINDER_FOX_PREF + "." +  REMINDER_FOX_ALARM_SOUND_INTERVAL);	
	 }
	 catch ( e) {
	 }
	
	if ( soundInterval > 0 ) {
		setInterval( playAlarmSound, (soundInterval*1000*60) );
	}
	
	sizeToContent();
}



function selectAlarmTab(){
	reminderFox_QAcalendarOpened = false;

	//sizeToContent();
	updateTimeUntil();
	
	//update window title
	var tabList = document.getElementById("tabList");
	var index = tabList.selectedIndex;
	var listName = reminderAlarmArray[index].alarmListName;
	
	var alarmMissed = reminderAlarmArray[index].alarmAlarmMissed;
	var recentReminder = reminderAlarmArray[index].alarmRecentReminder;
	
	var tabbox = document.getElementById("tabbox");
	var tabPanel = tabbox.selectedPanel;

	if ( (recentReminder !=null && recentReminder.notes != null) ||
		(reminderAlarmArray[index].quickAlarmNotes != null  && reminderAlarmArray[index].quickAlarmNotes.length > 0  &&
			reminderAlarmArray[index].quickAlarmNotes != "null") ) { 
		if ( reminderAlarmArray[index].quickAlarmNotes != null&& reminderAlarmArray[index].quickAlarmNotes.length > 0 &&
			reminderAlarmArray[index].quickAlarmNotes != "null" ) {
			getChildElementById(tabPanel, "notesText").setAttribute("value", reminderAlarmArray[index].quickAlarmNotes);		
		}
		else {
			getChildElementById(tabPanel, "notesText").setAttribute("value", recentReminder.notes);
		}		
		getChildElementById(tabPanel, "notesText").removeAttribute( "hidden");
		getChildElementById(tabPanel, "notesHbox").removeAttribute( "hidden");
	}
	else {
		getChildElementById(tabPanel, "notesText").setAttribute("value", null);	
		getChildElementById(tabPanel, "notesHbox").setAttribute( "hidden", true);	
		getChildElementById(tabPanel, "notesText").setAttribute( "hidden", true);
	}
	
	document.title =reminderFox_getBundle().getString( "rf.alarm.title" );
	if ( listName != null && listName.length > 0 && listName != "null" ) {
		document.title += " [" + listName  + "]";
	}
	
	// if this is a past reminder, indicate that in the title
	if ( alarmMissed != null && alarmMissed == "true" ) {
		// only show missed if the event itself has been missed...
		var currentDate = new Date();
		var compare = 0;
		if ( recentReminder.allDayEvent )  {
			// compare dates
			compare = reminderFox_compareDates( currentDate, recentReminder.date );
		}
		else {
			// compare dates and times
			compare = reminderFox_compareAlarmTimes( currentDate, recentReminder.date );
		}
		
		if ( compare == 1 ) {
		// compare Dates: recentReminder.date, currentDate.  
		// if current date is after reminder date, show 'missed'
			document.title = 	document.title + " (" + reminderFox_getBundle().getString( "rf.alarm.missedalarm.title" )  + ")";
		}
	}
	
	if ( recentReminder != null ) {
		document.title = 	document.title + ": " + recentReminder.summary;
	}
	else {
		document.title = 	document.title + ": " + reminderAlarmArray[index].quickAlarmText;
	}
}

function reminderFox_updateSnoozeTimeDate() {
	var tabList = document.getElementById("tabList");
	var index = tabList.selectedIndex;
	
		var recentReminder = reminderAlarmArray[index].alarmRecentReminder;
		var snoozeTimeList2 = getChildElementByIdForCurrentTab("reminderFox-snoozeTime");	
		var snoozeTime2 = snoozeTimeList2.label;
		if ( reminderFox_isInteger( snoozeTime2 ) ) {
			var timeUnitsList2 = getChildElementByIdForCurrentTab('reminderFox-alertTimeUnits');			
			if ( timeUnitsList2 != null ) { 
				var timeSelected2 = timeUnitsList2.selectedIndex;
				if ( timeSelected2 == 1 ) {
					snoozeTime2 = snoozeTime2 * 60;
				}
				else if ( timeSelected2== 2 ) {
					snoozeTime2 = snoozeTime2 * 60 * 24;
				}	
			}				
			
			var currentTimeDate = new Date();
			var currentTime2 = currentTimeDate.getTime();
			var alarmTime2 = currentTime2 + (snoozeTime2*60000);		
			var snoozeDate2 = new Date();
			snoozeDate2.setTime( alarmTime2 );
			
			var snoozeString = "";
			
			if ( snoozeDate2.getMonth() != currentTimeDate.getMonth() ||
				snoozeDate2.getDate() != currentTimeDate.getDate() ) {
				if ( recentReminder == null ) {
					snoozeString = 	 reminderFox_getDateVariableStringAlarm( null , snoozeDate2) + ", ";
				}
				else {
					snoozeString = 	 reminderFox_getDateVariableStringAlarm( recentReminder, snoozeDate2) + ", ";
				}
			}
			
			
			snoozeString += reminderFox_mail_getTimeString(snoozeDate2);
			
			getChildElementByIdForCurrentTab("snoozeUntilTime").setAttribute( "value", snoozeString);
		}
}

function reminderFox_getDateVariableStringAlarm(reminder, date )  {
	var dateVariableString = reminderFox_getUnicodePref(REMINDER_FOX_PREF + "." + REMINDER_FOX_LIST_DATE_LABEL);
	return reminderFox_getDateVariable( reminder, date, dateVariableString );
}


	
function reminderFox_compareAlarmTimes( dateOne, dateTwo ) {	
	var compare = reminderFox_compareDates( dateOne, dateTwo );
	if ( compare == 0 ) {
		if ( dateOne.getHours() < dateTwo.getHours() ) {
			return -1;
		}
		else if ( dateOne.getHours() > dateTwo.getHours() ) {
			return 1;
		}
		else {
			var diff = Math.abs(dateOne.getMinutes() - dateTwo.getMinutes() );
			if ( diff <= 2 ) { // within 2 minutes
				return 0;
			}
			
			if ( dateOne.getMinutes() < dateTwo.getMinutes() ) {
				return -1;
			}
			else if ( dateOne.getMinutes() > dateTwo.getMinutes() ) {
				return 1
			}
			else {
				return 0; // identical times
			}			
		}
	}
	
	return compare;
}

function reminderFox_launchAlarmURL() {   
    var urlText = getChildElementByIdForCurrentTab("urlText");
	if ( urlText.getAttribute( "reminderHref" ) != "" ) {	
  	  reminderFox_openURL(  urlText.getAttribute( "reminderHref" ) );
	}
}

function showMailInAlarm() {
	var displayMailButton = getChildElementByIdForCurrentTab("displayMail");
	displayMailButton.setAttribute( "checked", false 	);
	
	var tabList = document.getElementById("tabList");
	var index = tabList.selectedIndex;
	var recentReminder = reminderAlarmArray[index].alarmRecentReminder;
	reminderFox_displayMailbyMsgID(recentReminder);
}

function playAlarmSound() {
	// play a sound for notification (if the user elects to)
	try {
		var playSound = true;
		try {
			playSound = reminderFox_prefs.getBoolPref(REMINDER_FOX_PREF + "." +  REMINDER_FOX_ALARM_SOUND);
		}
		catch ( e) {
		}
		if ( playSound ) {
			reminderFox_playSound();
			window.focus();
			// TODO: could select the appropriate tab ?  Or that might be annoying
	  	} // end if		
	}
	catch ( e ) {
	}
}

function reminderFox_editReminderFromAlarm() {
	var tabList = document.getElementById("tabList");
	var index = tabList.selectedIndex;
	var reminderID = reminderAlarmArray[index].alarmCurrentAlarmId;
	if ( reminderID != null ) {
		var isReminder = reminderAlarmArray[index].alarmIsReminder;
		var isReminderType = (isReminder == "true" || isReminder == true );
		reminderFox_editEventHeadlessly( reminderID, null, isReminderType );
	}
}

function reminderFox_alarmDone() {
	reminderFox_okayed = true;
	var actionList = getChildElementByIdForCurrentTab("reminderFox-alarm-action");
	var actionIndex =	actionList.selectedIndex;	
	
	// if quickalarm
	var tabList = document.getElementById("tabList");
	var index = tabList.selectedIndex;
	var quickAlarmText = 	reminderAlarmArray[index].quickAlarmText;	
	if (quickAlarmText != null ) { 
		reminderFox_removeQuickAlarm( quickAlarmText );
		reminderFox_closeAlarmTab();
	}
	else {
		reminderFox_performAlarmAction( actionIndex );
	}
}

/**
 * This function is called when closing the window with ESC or 'X'.  It will not ACKNOWLEDGE
 * the reminder alarm; only dismiss it.  You will be alerted the next time the alarms get 
 * processed.
 */
function reminderFox_alarmClosed(closeAll) {
	// clear the alarm ID from the list, so that it will get processed the next time
	// (unless the alarm was snoozed or okayed; in that case we don't want to call this function)
	// TODO: need to remove all alarms...
	var tabList = document.getElementById("tabList");
	var index = tabList.selectedIndex;
	
	
	if ( !reminderFox_snoozed && !reminderFox_okayed && !reminderFox_reopeningWindow ) { 
		for (var j = 0; j < reminderAlarmArray.length; j++) {
			if (closeAll || j == index) {
				
				if ( reminderAlarmArray[j].quickAlarmText != null ) { 
					//reminderFox_removeQuickAlarm( reminderAlarmArray[j].quickAlarmText );
				}
				else{
					var myAlarmId = reminderAlarmArray[j].alarmCurrentAlarmId;
					var windowEnumerator = reminderFox_getWindowEnumerator();
					if (windowEnumerator.hasMoreElements()) {
						var oldestWindow = windowEnumerator.getNext();
						for (var i = 0; i < oldestWindow.reminderFox_alarmList.length; i++) {
							var currentAlarmId = oldestWindow.reminderFox_alarmList[i].alarmId;
							if (currentAlarmId == myAlarmId) {
								reminderFox_removeElement(oldestWindow.reminderFox_alarmList, i);
							}
						}
					}
				}
			}
		}
	}
	
	
	reminderFox_okayed = false;
	reminderFox_snoozed = false;
	if (!closeAll) {
		reminderFox_closeAlarmTab();
		selectAlarmTab();
	}
		
	
	//reminderFox_performAlarmAction( REMINDERFOX_ACTION_TYPE.ACKNOWLEDGE );  // default action - acknowledge
}

function reminderFox_closeAlarmTab() {
// close a tab
	var tabList = document.getElementById("tabList");
	var selectedIndex = tabList.selectedIndex;
	var tabbox = document.getElementById("tabbox");
	var panel = tabbox.selectedPanel;
	var tabPanels = document.getElementById("tabPanelID");
	
	if (tabList.childNodes.length > 1) {
		tabList.removeItemAt(selectedIndex);
		tabPanels.removeChild( panel );
		if (selectedIndex >= tabList.childNodes.length - 1) {
			tabList.selectedIndex = tabList.childNodes.length - 1;
		}
		else {
			tabList.selectedIndex = selectedIndex;
		}
		reminderFox_removeElement( reminderAlarmArray, selectedIndex );
		
		reminderFox_snoozed = false;
		reminderFox_okayed = false;
		
		selectAlarmTab();
	}
	else {
		window.close();
	}
	
	
}

function reminderFox_performAlarmAction(actionIndex, snoozeTime, alarmTime, keepOpen){
	var tabList = document.getElementById("tabList");
	var index = tabList.selectedIndex;
	var myAlarmId = reminderAlarmArray[index].alarmCurrentAlarmId;
	var listName = reminderAlarmArray[index].alarmListName;
	
	if (reminderFox_snoozed && actionIndex != REMINDERFOX_ACTION_TYPE.SNOOZE) { // if the alarm is snoozed, we'll do nothing
		return;
	}
	if (actionIndex == REMINDERFOX_ACTION_TYPE.OPEN) {
		// reset to Acknowledge after opened...
		var actionList = getChildElementByIdForCurrentTab("reminderFox-alarm-action");
		actionList.selectedIndex = REMINDERFOX_ACTION_TYPE.ACKNOWLEDGE;
		
		reminderFox_editReminderFromAlarm();
		
		return;
	}
	
	
	var isReminder = reminderAlarmArray[index].alarmIsReminder;
	var reminder;
	
	// need to clear my reminders/todos from memory (as they may have changed in edit window)
	// and refresh them	
	reminderFox_clearRemindersAndTodos();
	if (isReminder == "true" || isReminder == true) {
		reminder = reminderFox_getRemindersById(myAlarmId);
	}
	else {
		reminder = reminderFox_getSpecificTodoById(myAlarmId);
	}
	
	
	// mark reminder's last-acknowleged  (unless snooze was pressed)
	if (reminder != null) {
		var removed = false;
		var completed = false;
		if (actionIndex == REMINDERFOX_ACTION_TYPE.SNOOZE) {
			reminder.snoozeTime = alarmTime + ";PT" + snoozeTime + "M";
		}
		else {
			reminder.alarmLastAcknowledge = new Date().getTime();
			reminderFox_logMessageLevel("Setting acknowledge for alarm: " + reminder.alarmLastAcknowledge   , REMINDER_FOX_LOG_LEVEL_SUPER_FINE);  //TODO //dump()

			reminder.snoozeTime = null; // clear snooze time
		}
		reminderFox_lastModifiedTime = reminderFox_prefs.getCharPref(REMINDER_FOX_PREF + "." + REMINDER_FOX_LAST_MODIFIED) + "";
		
		if (actionIndex == REMINDERFOX_ACTION_TYPE.COMPLETE) {
			reminder.completedDate = new Date();
			
			// if reminder is marked as Remind Until Complete, clear it (if one-time, clear the RUC completely;
			// if a repeating reminder, simply change back to RUC-marked)  and update the reminder
			//  in the list (as the current reminder instance may be removed)
			if (reminder.recurrence.type == REMINDER_RECURRENCE_ONETIME &&
			(reminder.remindUntilCompleted == REMINDERFOX_REMIND_UNTIL_COMPLETE_TO_BE_MARKED ||
			reminder.remindUntilCompleted == REMINDERFOX_REMIND_UNTIL_COMPLETE_MARKED)) {
				reminder.remindUntilCompleted = REMINDERFOX_REMIND_UNTIL_COMPLETE_NONE;
				
			}
			else 
				if ((isReminder == "true" || isReminder == true ) && reminder.remindUntilCompleted == REMINDERFOX_REMIND_UNTIL_COMPLETE_MARKED) {
					reminder.remindUntilCompleted = REMINDERFOX_REMIND_UNTIL_COMPLETE_TO_BE_MARKED;
				}
			
			completed = true;
		}
		else 
			if (actionIndex == REMINDERFOX_ACTION_TYPE.DELETE) {
				// remove from model list
				if (isReminder == "true" || isReminder == true) {
					var reminders = reminderFox_getReminderEvents();
					
					var currentReminder = reminderAlarmArray[index].alarmRecentReminder;
					var messageID = currentReminder.messageID;
					
					if (currentReminder.recurrence.type == REMINDER_RECURRENCE_MONTHLY_DATE ||
					currentReminder.recurrence.type == REMINDER_RECURRENCE_MONTHLY_DAY ||
					currentReminder.recurrence.type == REMINDER_RECURRENCE_WEEKLY ||
					currentReminder.recurrence.type == REMINDER_RECURRENCE_DAILY) {
					
						// prompt user... 
						var deleteRecurrenceOnly = true;
						var deleteDate = new Date(currentReminder.date.getFullYear(), currentReminder.date.getMonth(), currentReminder.date.getDate(), currentReminder.date.getHours(), currentReminder.date.getMinutes());
						var dateLabel = reminderFox_getDateVariableString(currentReminder, deleteDate);
						
						var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(Components.interfaces.nsIPromptService);
						var deleteDescription = g_reminderFoxBundle.getString("rf.add.deleteReminderInstance.description") + "\n";
						deleteDescription += dateLabel + ": " + currentReminder.summary + "\n";
						var flags = promptService.BUTTON_TITLE_IS_STRING * promptService.BUTTON_POS_0 +
						promptService.BUTTON_TITLE_IS_STRING * promptService.BUTTON_POS_1 +
						promptService.BUTTON_TITLE_IS_STRING * promptService.BUTTON_POS_2;
						var msg = deleteDescription;
						var buttonPressed = promptService.confirmEx(window, g_reminderFoxBundle.getString("rf.add.deleteReminder.title"), msg, flags, g_reminderFoxBundle.getString("rf.add.deleteReminderInstance.all.button"), g_reminderFoxBundle.getString("rf.button.cancel"), g_reminderFoxBundle.getString("rf.add.deleteReminderInstance.currentInstance.button"), null, {});
						
						// cancel pressed
						if (buttonPressed == 1) {
							return;
						}
						
						// curent instances pressed
						if (buttonPressed == 2) {
							if (deleteDate != null) {
								deleteDate.setDate(deleteDate.getDate() + 1);
								var instanceReminder = reminderFox_getFirstReminderOccurrenceAfterStartDate(currentReminder, deleteDate);
								var newReminderDate = instanceReminder.date;
								var newReminder = reminderFox_cloneReminderFoxEvent(currentReminder);
								newReminder.date = newReminderDate;
								
								// if the date has changed, treat as a new reminder.  This is because 
								// We want to re-add in the proper sorted order into the list of reminders
								var reminders = reminderFox_getReminderEvents();
								for (var i = 0; i < reminders.length; i++) {
									if (reminders[i].id == currentReminder.id) {
										reminderFox_removeElement(reminders, i);
										removed = true;
										break;
									}
								}
								
								// add reminder in sorted order...
								reminders = reminderFox_getReminderEvents();
								if (newReminder.remindUntilCompleted != REMINDERFOX_REMIND_UNTIL_COMPLETE_NONE) {
									newReminder.remindUntilCompleted = REMINDERFOX_REMIND_UNTIL_COMPLETE_TO_BE_MARKED;
								}
								
								var sortedIndex = reminderFox_getSortedIndexOfNewReminder(reminders, newReminder, false);
								reminderFox_insertIntoArray(reminders, newReminder, sortedIndex);
							}
						}
						else {
							// delete all instances pressed  
							for (var i = 0; i < reminders.length; i++) {
								if (reminders[i].id == reminder.id) {
									reminderFox_removeElement(reminders, i);
									removed = true;
									break;
								}
							}
						}
					}
					else {
						// for non-repeat (and yearly) just delete
						var reminders = reminderFox_getReminderEvents();
						for (var i = 0; i < reminders.length; i++) {
							if (reminders[i].id == reminder.id) {
								reminderFox_removeElement(reminders, i);
								removed = true;
								break;
							}
						}
					}
				}
				else {
					var reminderFoxTodosArrayArg = reminderFox_getReminderTodos();
					for (var n in reminderFoxTodosArrayArg) {
						var reminderTodos = reminderFoxTodosArrayArg[n];
						for (i = 0; i < reminderTodos.length; i++) {
							if (reminderTodos[i].id == reminder.id) {
								reminderFox_removeElement(reminderTodos, i);
								removed = true;
								break;
							}
						}
					}
				}
			}
		
		if (actionIndex == REMINDERFOX_ACTION_TYPE.COMPLETE ||
				actionIndex == REMINDERFOX_ACTION_TYPE.DELETE ||
				actionIndex == REMINDERFOX_ACTION_TYPE.SNOOZE) { // we want to write out the file and mark it changed - and sync w/ network
			reminderFox_writeOutRemindersAndTodos(false);
			
			// this callback syncs the written changes to remote and does it in the background on the calling 
			// window (otherwise we have to keep this window open until the network function callback returns)
			var tabList = document.getElementById("tabList");
			var index = tabList.selectedIndex;
			var recentReminder = reminderAlarmArray[index].alarmRecentReminder;
			var syncCallback = reminderAlarmArray[index].synccallback;
			if (syncCallback != null) {
				var networkSync = REMINDER_FOX_NETWORK_SYNCHRONIZE_DEFAULT;
				try {
					networkSync = reminderFox_prefs.getBoolPref(REMINDER_FOX_PREF + "." + REMINDER_FOX_NETWORK_SYNCHRONIZE);
				} 
				catch (e) {
				}
				if (networkSync) {
					syncCallback();
				}
			}
		}
		else {
			// if we just acknowledged the reminder, don't do anything.  
			reminderFox_writeOutRemindersAndTodos(false);
		}
		
	   
	   reminderFox_logMessageLevel("Alarm action'd; looking to remove from alarm list"   , REMINDER_FOX_LOG_LEVEL_SUPER_FINE);  //TODO //dump()

		if (actionIndex != REMINDERFOX_ACTION_TYPE.SNOOZE && !reminderFox_reopeningWindow) {
			var windowEnumerator = reminderFox_getWindowEnumerator();
			if (windowEnumerator.hasMoreElements()) {
				var oldestWindow = windowEnumerator.getNext();
				for (var i = 0; i < oldestWindow.reminderFox_alarmList.length; i++) {
					var currentAlarmId = oldestWindow.reminderFox_alarmList[i].alarmId;   
					if (currentAlarmId == myAlarmId) {
	   					reminderFox_logMessageLevel("Removing...."   , REMINDER_FOX_LOG_LEVEL_SUPER_FINE);  //TODO //dump()

						reminderFox_removeElement(oldestWindow.reminderFox_alarmList, i);
						reminderFox_logMessageLevel("Removed...."   , REMINDER_FOX_LOG_LEVEL_SUPER_FINE);  //TODO //dump()
					}
				}
			}
		}
		
		
		
		// if the edit window is open and we Acknowledge this alarm, we need to set the lastAck  for this reminder instnace 
		// in the editWindow as well, or it will still have the old value and overwrite the correct one when the edit 
		// window is closed...
		var windowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService();
		var windowManagerInterface = windowManager.QueryInterface(Components.interfaces.nsIWindowMediator);
		var topWindow = windowManagerInterface.getMostRecentWindow("window:reminderFoxEdit");
		if (topWindow) {
			var editWindowReminder = null;
			if (isReminder == "true" || isReminder == true) {
				editWindowReminder = topWindow.reminderFox_getRemindersById(myAlarmId);
			}
			else {
				var arrName = listName;
				if (arrName == null || arrName == "") {
					arrName = REMINDER_FOX_DEFAULT_TODOS_CATEGORY;
				}
				
				var todosArr = topWindow.reminderFox_getReminderTodos();
				var todos = todosArr[arrName];
				if (todos == null) {
					todos = new Array();
				}
				
				editWindowReminder = topWindow.reminderFox_getTodosById(myAlarmId, todos);
			}
			if (editWindowReminder != null) {
				if (actionIndex != REMINDERFOX_ACTION_TYPE.SNOOZE && reminder.alarmLastAcknowledge != null) {
					editWindowReminder.alarmLastAcknowledge = reminder.alarmLastAcknowledge;
				}
				
				if (actionIndex == REMINDERFOX_ACTION_TYPE.COMPLETE) {
					editWindowReminder.completedDate = new Date();
					// if reminder is marked as Remind Until Complete, clear it (if one-time, clear the RUC completely;
					// if a repeating reminder, simply change back to RUC-marked)  and update the reminder
					//  in the list (as the current reminder instance may be removed)
					if (editWindowReminder.recurrence.type == REMINDER_RECURRENCE_ONETIME &&
					(editWindowReminder.remindUntilCompleted == REMINDERFOX_REMIND_UNTIL_COMPLETE_TO_BE_MARKED ||
					editWindowReminder.remindUntilCompleted == REMINDERFOX_REMIND_UNTIL_COMPLETE_MARKED)) {
						editWindowReminder.remindUntilCompleted = REMINDERFOX_REMIND_UNTIL_COMPLETE_NONE;
					}
					else 
						if (editWindowReminder.remindUntilCompleted == REMINDERFOX_REMIND_UNTIL_COMPLETE_MARKED) {
							editWindowReminder.remindUntilCompleted = REMINDERFOX_REMIND_UNTIL_COMPLETE_TO_BE_MARKED;
						}
					
					if (isReminder == "true" || isReminder == true) {
						var modified = topWindow.updateReminderInList(editWindowReminder);
					}
					else {
						var modified = topWindow.updateTodoInList(editWindowReminder)
					}
					topWindow.modifiedReminders();
					
				}
				else 
					if (actionIndex == REMINDERFOX_ACTION_TYPE.SNOOZE) {
						editWindowReminder.snoozeTime = reminder.snoozeTime;
						if (isReminder == "true" || isReminder == true) {
							var modified = topWindow.updateReminderInList(editWindowReminder);
						}
						else {
							var modified = topWindow.updateTodoInList(editWindowReminder)
						}
						topWindow.modifiedReminders();
					}
					else 
						if (actionIndex == REMINDERFOX_ACTION_TYPE.DELETE) {
							if (isReminder == "true" || isReminder == true) {
								// remove from UI list
								topWindow.removeListItemsForReminder(editWindowReminder);
								
								// remove from model list
								var reminders = topWindow.reminderFox_getReminderEvents();
								for (var i = 0; i < reminders.length; i++) {
									if (reminders[i].id == editWindowReminder.id) {
										topWindow.reminderFox_removeElement(reminders, i);
										break;
									}
								}
							}
							else {
								// remove from UI list
								topWindow.removeTodoListItem(editWindowReminder);
								
								// remove from model list
								var reminderFoxTodosArrayArg = topWindow.reminderFox_getReminderTodos();
								for (var n in reminderFoxTodosArrayArg) {
									var reminderTodos = reminderFoxTodosArrayArg[n];
									for (i = 0; i < reminderTodos.length; i++) {
										if (reminderTodos[i].id == editWindowReminder.id) {
											topWindow.reminderFox_removeElement(reminderTodos, i);
											break;
										}
									}
								}
							}
							topWindow.modifiedReminders();
						}
			}
		}
		
	//	if (completed || removed) {
	if ( true ) {  // 02/10/11 - changed to if (true) b/c acknowleging wasn't setting this flag and would cause a duplicate reminder when the hourly processing ran
			reminderFox_clearRemindersAndTodos();
			// update all of the browsers
			windowEnumerator = reminderFox_getWindowEnumerator();
			while (windowEnumerator.hasMoreElements()) {
				var currentWindow = windowEnumerator.getNext();
				currentWindow.reminderFoxEvents = reminderFoxEvents;
				currentWindow.reminderFoxTodosArray = reminderFoxTodosArray;
				
				currentWindow.reminderFox_updateRemindersInWindow();
				currentWindow.reminderFox_clearRemindersAndTodos();
			}
		}
	}
	
	if (!keepOpen) {
		reminderFox_closeAlarmTab();
	}
}

function reminderFox_alarmChooseDone() {
	reminderFox_okayed = true;
	if ( 	getChildElementByIdForCurrentTab("snoozeButton").getAttribute( "default" ) == true ||
		getChildElementByIdForCurrentTab("snoozeButton").getAttribute( "default" ) == "true"	) {
		reminderFox_snooze();
	}
	else {
		reminderFox_alarmDone();
	}
}

function popupClosedAlarm(element) {	   
	// we'll calculate the difference between now and the selected date
	// and set the snooze to that number of minutes
	var currentDate = new Date();
	currentDate.setSeconds(0);
	currentDate.setMilliseconds(0);
	var currentDateTime = currentDate.getTime();
	
	var selectedDate = oeDatePicker.gSelectedDate;
	selectedDate.setSeconds(0);
	selectedDate.setMilliseconds(0);
	var selectedTime = selectedDate.getTime();
	
	var time = currentDateTime;
	if ( selectedTime > currentDateTime ) {
		var timeDiff = selectedTime - currentDateTime;
		var minutesDiff = timeDiff / 1000 / 60;
		var snoozeTimeList = getChildElementByIdForCurrentTab("reminderFox-snoozeTime");	 // alarm
		var snoozeTimeInt = Math.round( parseInt(minutesDiff));
		
		var timeUnitsList = getChildElementByIdForCurrentTab('reminderFox-alertTimeUnits');			
		if (  reminderFox_mod( snoozeTimeInt , (60 * 24) ) == 0 ) { 
			// days
			snoozeTimeList.label =( snoozeTimeInt / (60*24) );
			timeUnitsList.selectedIndex = 2;			
		}
		else if (  reminderFox_mod( snoozeTimeInt , 60 ) == 0 ) { 
			// hours
			snoozeTimeList.label = (snoozeTimeInt / 60);	
			timeUnitsList.selectedIndex = 1;
		}
		else {
			// minutes
			snoozeTimeList.label = snoozeTimeInt;
			
			timeUnitsList.selectedIndex = 0;
		}
		
		// need to call the alarm dialog snooze stuff now...
		reminderFox_snoozeTimeChanged();
	}
	else { 
		if ( selectedDate.getHours() > 0 || selectedDate.getMinutes() > 0 ) { // if any time was set other than default
			alert( reminderFox_getBundle().getString( "rf.add.time.button.calendar.date.select.invalid" ) );
		}
	}
}


function reminderFox_snoozeTimeChanged() {
	getChildElementByIdForCurrentTab("snoozeButton").setAttribute( "default", true );
	getChildElementByIdForCurrentTab("okButton").setAttribute( "default", false );
	
	reminderFox_updateSnoozeTimeDate();
}


function getRF_alarmIndex() {
	var tabList = document.getElementById("tabList");
	var selectedIndex = tabList.selectedIndex;
	return selectedIndex;
}

function getRF_AlarmArray() {
	var tabList = document.getElementById("tabList");
	var selectedIndex = tabList.selectedIndex;
	return window.arguments[0].alarmInfos;
}

function reminderFox_snooze() {
		var tabList = document.getElementById("tabList");
		var selectedIndex = tabList.selectedIndex;
		
		
		var tabbox = document.getElementById("tabbox");
		var panel = tabbox.selectedPanel;
		var tabPanels = document.getElementById("tabPanelID");
	
		reminderFox_snoozed = true;
		
		var tabList = document.getElementById("tabList");
		var index = tabList.selectedIndex;
		var currentAlarmId = reminderAlarmArray[index].alarmCurrentAlarmId;
		var recentReminder = reminderAlarmArray[index].alarmRecentReminder;
		var isReminder = reminderAlarmArray[index].alarmIsReminder;
		var listName = reminderAlarmArray[index].alarmListName;		
		var quickAlarmText = 	reminderAlarmArray[index].quickAlarmText;	
		
		var snoozeTimeList = getChildElementByIdForCurrentTab("reminderFox-snoozeTime");	
		var snoozeTime = snoozeTimeList.label;
		if ( reminderFox_isInteger( snoozeTime ) ) {
			var timeUnitsList = getChildElementByIdForCurrentTab('reminderFox-alertTimeUnits');			
			if ( timeUnitsList != null ) { 
				var timeSelected = timeUnitsList.selectedIndex;
				if ( timeSelected == 1 ) {
					snoozeTime = snoozeTime * 60;
				}
				else if ( timeSelected == 2 ) {
					snoozeTime = snoozeTime * 60 * 24;
				}	
			}				
			
			var currentTime = new Date().getTime();
			var alarmTime = currentTime + (snoozeTime*60000);		
					
			var windowEnumerator =  reminderFox_getWindowEnumerator();
			
			if ( quickAlarmText != null ) {
				if (windowEnumerator.hasMoreElements()) {
					var oldestWindow = windowEnumerator.getNext();	
					
					var setSnoozeTime = snoozeTime*60000;
					if ( setSnoozeTime == 0 ) {
						setSnoozeTime = 1000;
					}
					var notes = null;
					if ( reminderAlarmArray[index].quickAlarmNotes != null && 
							reminderAlarmArray[index].quickAlarmNotes.length > 0  &&
							reminderAlarmArray[index].quickAlarmNotes != "null") {	
						 notes =reminderAlarmArray[index].quickAlarmNotes.replace(new RegExp(/\n/g),"\\n");
						 
						 reminderFox_logMessageLevel( new Date()  + "; alarm: Setting showAlarm timeout1: " + quickAlarmText + "--" + snoozeTime + " --> " + (snoozeTime*60000) + "--" +  setSnoozeTime  , REMINDER_FOX_LOG_LEVEL_SUPER_FINE);  //TODO
						oldestWindow.setTimeout(function() { oldestWindow.reminderFox_showQuickAlarm(quickAlarmText,snoozeTime,notes) } , setSnoozeTime);

					}
					else {
					 	reminderFox_logMessageLevel( new Date()  + "; alarm: Setting showAlarm timeout2: " + quickAlarmText + "--" + snoozeTime + " --> " + (snoozeTime*60000) + "--" +  setSnoozeTime  , REMINDER_FOX_LOG_LEVEL_SUPER_FINE);  //TODO
						oldestWindow.setTimeout(function() { oldestWindow.reminderFox_showQuickAlarm(quickAlarmText,snoozeTime) } , setSnoozeTime);

					}
										
					reminderFox_updateQuickAlarms( quickAlarmText, snoozeTime, notes );	
				}
			}
			else {
				if (windowEnumerator.hasMoreElements()) {
					var oldestWindow = windowEnumerator.getNext();
					
					// update existing entry from alarm list with snooze set and updated alarmTime
					for ( var i = 0; i < oldestWindow.reminderFox_alarmList.length; i++ ) {
						var myAlarmId =  oldestWindow.reminderFox_alarmList[i].alarmId;
						if ( currentAlarmId == myAlarmId ) { 
							oldestWindow.reminderFox_alarmList[i].snoozed = true;
							oldestWindow.reminderFox_alarmList[i].timeOfAlarm = alarmTime;
						}
					}
					if ( listName == null ){
						listName = "";
					}			
				
					reminderFox_performAlarmAction( REMINDERFOX_ACTION_TYPE.SNOOZE, snoozeTime, alarmTime, true);			
					
					reminderFox_logMessageLevel( "alarm: Setting showAlarm timeout: " + snoozeTime + " --> " + (snoozeTime*60000)   , REMINDER_FOX_LOG_LEVEL_SUPER_FINE);  //TODO
					var alarmArray = new Array();
					alarmArray[alarmArray.length] = reminderAlarmArray[index];
									
					var isAlarmMissed = "false";
					if ( reminderAlarmArray[index].alarmAlarmMissed == "true" || 
						reminderAlarmArray[index].alarmAlarmMissed == true ) {
						isAlarmMissed = "true";
					}
					
					
					var setSnoozeTime = snoozeTime*60000;
					if ( setSnoozeTime == 0 ) {  
						setSnoozeTime = 1000;
					}
					 reminderFox_logMessageLevel( new Date()  + "; alarm: Setting reminderFox_showMissedAlarmsSnooze timeout3: " + reminderAlarmArray[index].alarmRecentReminder.id + "--"  +  setSnoozeTime  , REMINDER_FOX_LOG_LEVEL_SUPER_FINE);  //TODO

				
// dump: nls - fix here
// if snooze time is > minutes * 60 *24 * 24 (60mins*24hrs*24 days) then don't set the timeout
// here we go:
// http://stackoverflow.com/questions/3468607/why-does-settimeout-break-for-large-millisecond-delay-values
//Timeout values too big to fit into a signed 32-bit integer may cause overflow in FF, Safari, and Chrome, resulting in the timeout being scheduled immediately. It makes more sense simply not to schedule these timeouts, since 24.8 days is beyond a reasonable expectation for the browser to stay open.
					oldestWindow.setTimeout(oldestWindow.reminderFox_showMissedAlarmsSnooze, 
						setSnoozeTime,
						snoozeTime, 
						reminderAlarmArray[index].alarmRecentReminder.id,
						reminderAlarmArray[index].alarmListName,
						reminderAlarmArray[index].alarmTimeString,
						reminderAlarmArray[index].alarmIsReminder,
						reminderAlarmArray[index].alarmIsTodo,
						reminderAlarmArray[index].alarmAlarmMissed,
						reminderAlarmArray[index].reminderTime,
						reminderAlarmArray[index].reminderTimeDifference );
						
					
				}	
			}	
		}
		
		// close the tab if there is multiple tabs...
		reminderFox_closeAlarmTab();
}





function reminderFox_updateQuickAlarms( quickAlarmText, snoozeTime, notesText ) {	
	var currentTime = new Date().getTime();
	currentTime = currentTime + (snoozeTime*60000);
	
	var newQuickAlarm = new ReminderFoxQuickAlarm( quickAlarmText, notesText, currentTime,  snoozeTime );
	reminderFox_updateQuickAlarm( newQuickAlarm );
}


function reminderFox_cloneAlarmInfo( originalAlarm ) {


var clonedAlarm = 
{
	alarmTabPanel: originalAlarm.alarmTabPanel,
	alarmRecentReminder: reminderFox_cloneReminderFoxTodo(originalAlarm.alarmRecentReminder),
	alarmSnoozeTime: originalAlarm.alarmSnoozeTime,
	alarmListName: originalAlarm.alarmListName,
	reminderTime: originalAlarm.reminderTime, 
	alarmTimeString: originalAlarm.alarmTimeString,
	alarmIsTodo: originalAlarm.alarmIsTodo,
	alarmIsReminder: originalAlarm.alarmIsReminder,
	alarmAlarmMissed: originalAlarm.alarmAlarmMissed,
	alarmCurrentAlarmId: originalAlarm.alarmCurrentAlarmId,
	synccallback: originalAlarm.synccallback,
	clearLabelCallback: originalAlarm.clearLabelCallback
}


return clonedAlarm;
}


function reminderFox_actionChanged() { 
	var actionList = getChildElementByIdForCurrentTab("reminderFox-alarm-action");
	var actionIndex =	actionList.selectedIndex;		
	// if the user has selected OPEN... open the reminder now
	if ( actionIndex == REMINDERFOX_ACTION_TYPE.OPEN ) { 
		reminderFox_performAlarmAction( actionIndex );
	}	
}


function reminderfox_showCalendarQA(event) {
	if ( !reminderFox_QAcalendarOpened ) {
		var reminderDate =  new Date();
		reminderDate.setHours(0);
		reminderDate.setMinutes(0);
		reminderDate.setSeconds(0);


		var tabList = document.getElementById("tabList");
		var index = tabList.selectedIndex;
	
		var snoozeTimeList2 = getChildElementByIdForCurrentTab("reminderFox-snoozeTime");	
		var snoozeTime2 = snoozeTimeList2.label;
		if ( reminderFox_isInteger( snoozeTime2 ) ) {
			var timeUnitsList2 = getChildElementByIdForCurrentTab('reminderFox-alertTimeUnits');			
			if ( timeUnitsList2 != null ) { 
				var timeSelected2 = timeUnitsList2.selectedIndex;
				if ( timeSelected2 == 1 ) {
					snoozeTime2 = snoozeTime2 * 60;
				}
				else if ( timeSelected2== 2 ) {
					snoozeTime2 = snoozeTime2 * 60 * 24;
				}	
			}				
			
			var currentTimeDate = new Date();
			var currentTime2 = currentTimeDate.getTime();
			var alarmTime2 = currentTime2 + (snoozeTime2*60000);		
			var snoozeDate2 = new Date();
			snoozeDate2.setTime( alarmTime2 );
			reminderDate = snoozeDate2;
			
			// clear the time since it can not be properly set  (user can't directly edit the time field to say 12:37 for instance)
			reminderDate.setHours(0);
			reminderDate.setMinutes(0);
			reminderDate.setSeconds(0);
		}

		var timeList = document.getElementById("reminderFox-timeList");	
		timeList.label =  timeList.firstChild.childNodes[0].getAttribute("label");

		oeDatePicker.resizeCalendar();  
		
		oeDatePicker.onpopupshowing(reminderDate, true, true);	
		reminderFox_QAcalendarOpened = true;	
	}
}



function popupOk(element) {
	var popup = reminderFox_findParentById( element, "oe-date-picker-popup", "oe-date-picker-popup-end" );
	popup.hidePopup();
}

